library("BadRSQLite")
library("ggplot2")

# don't need this anymore bc ISO codes for Region are in ccodes table
# region <- c("AGO", "BWA", "LSO", "MWI", "MOZ", "NAM", "ZAF", "SWZ", "ZWB", "ZWE")

# get the db link and query it for southern Africa data
mydblink <- dbConnect(BadRSQLite::SQLite(), "AfricaCOVID.db")
regiondat <- dbGetQuery(mydblink, "SELECT COVID.* FROM COVID JOIN ccodes ON COVID.iso_code=ccodes.ISO3 WHERE ccodes.Region='Southern Africa';")
dbDisconnect(mydblink)

# make the date column into R dates, numeric columns into R numeric type
regiondat$date <- as.Date(regiondat$date) 
regiondat[5:16] <- apply(regiondat[5:16], 2, as.numeric)
zafdat <- subset(regiondat, iso_code = 'ZAF')

# plot the ZAF data with new cases and deaths, save as file 
p <- ggplot(zafdat, aes(x = date, y = new_cases_smoothed_per_million, group = location)) + 
  geom_line() + scale_x_date(date_breaks = "1 month", date_labels = "%b") + 
  ylab(label = "New cases or deaths per million, smoothed") 
p2 <- p + geom_line(aes(y = new_deaths_smoothed_per_million), colour= "red")
ggsave("zaf-plot.jpg", p2, width=20, height=8, units="cm")

# plot the data for all southern African countries 
p3 <- ggplot(regiondat, aes(x = date, y = new_cases_smoothed_per_million, group = location, color = location)) + 
  geom_line() + scale_x_date(date_breaks = "1 month", date_labels = "%b") + 
  ylab(label = "New cases per million, smoothed") 
# ggsave("southern-plot.jpg", p3, width=20, height=8, units="cm")
